### 功能块FB\_IotMqttClient介绍
![](https://resource.helplook.net/docker_production/3648ne/article/DHwrXFBI/6800eb1e8f185.png)


* 输入参数

| **参数名称**           | **参数类型**           | **描述说明**                                   |
| ------------------ | ------------------ | ------------------------------------------ |
| **sClientId**      | String             | mqtt的客户端Id,必须是唯一标识，不填有程序自动分配               |
| **sHostName**      | String             | mqtt的服务器的IP地址，默认为本机IP                      |
| **nHostPort**      | UINT               | mqtt服务器的端口，默认为1883                         |
| **sTopicPrefix**   | String             | 消息通道的前缀,订阅或者发布消息的时候需要添加这个前缀，可不填            |
| **nKeepAlive**     | UINT               | 心跳报文发送时间，默认为60秒                            |
| **sUserName**      | String             | 设置连接mqtt服务器用户名。如果Broker需要提供用户名和密码连接。       |
| **sUserPassword**  | String             | 设置连接mqtt服务器密码。如果Broker需要提供用户名和密码连接。        |
| **stWill**         | 结构体ST\_IotMqttWill | mqtt遗嘱消息，如果mqtt客户端发生异常断开，服务端会向指定的topic发送消息 |
| **stTLS**          | 结构体ST\_IotMqttTls  | mqtts 连接的时候，需要设置一些证书和密钥文件的路径，必须保证路径存在      |
| **ipMessageQueue** | 指针                 | 消息队列的指针，订阅消息时需要指向消息队列                      |

* 输出参数

| **参数名称**             | **参数类型** | **描述说明**                  |
| -------------------- | -------- | ------------------------- |
| **bError**           | Bool     | 是否报错，True为有错误，False为正常    |
| **hrErrorCode**      | UINT     | 错误码                       |
| **eConnectionState** | UINT     | mqtt的连接状态，枚举类型            |
| **bConnected**       | Bool     | 是否建立连接，True为连接，False为没有连接 |

---
**方法FB\_IotMqttClient.Execute()介绍**

Void **Execute(BOOL&#x20;**&#x62;Connec&#x74;**)；**

| **接口**       | **类型** | **说明**     |
| ------------ | ------ | ---------- |
| **bConnect** | BOOL   | TRUE表示建立连接 |

---
**方法FB\_IotMqttClient.Publish()介绍**

Bool **Publish(String&#x20;**&#x73;Topi&#x63;**，POINTER TO UDINT&#x20;**&#x70;Payloa&#x64;**,UDINT&#x20;**&#x6E;PayloadSiz&#x65;**,TcIotMqttQos&#x20;**&#x65;Qo&#x53;**,Bool&#x20;**&#x62;Retai&#x6E;**，Bool&#x20;**&#x62;Queu&#x65;**)；**

| **接口**             | **类型**           | **说明**                                                                                                          |
| ------------------ | ---------------- | --------------------------------------------------------------------------------------------------------------- |
| **sTopic**         | String           | 发布消息的主题                                                                                                         |
| **&#x20;pPayload** | PVOID            | 指针指向发布消息内容                                                                                                      |
| **nPayloadSize**   | UDINT            | 发布消息内容长度                                                                                                        |
| **eQoS**           | 枚举类型TcIotMqttQos | AtMostOnceDelivery := 0,       //最多一次AtLeastOnceDelivery :=1,       //至少一次ExactlyOnceDelivery := 2       //确切一次 |
| **bRetain**        | Bool             | TRUE表示发布保留消息                                                                                                    |
| **bQueue**         | Bool             | 保留勿用                                                                                                            |
| **返回值**            | Bool             | 发送是否成功，TRUE成功，FALSE不成功                                                                                          |


---
**方法FB\_IotMqttClient.Subscribe()介绍**

Bool **Subscribe(String&#x20;**&#x73;Topi&#x63;**，TcIotMqttQos&#x20;**&#x65;Qo&#x53;**)；**

| **接口**     | **类型**           | **说明**                                                                                                          |
| ---------- | ---------------- | --------------------------------------------------------------------------------------------------------------- |
| **sTopic** | String           | 订阅消息的主题                                                                                                         |
| **eQoS**   | 枚举类型TcIotMqttQos | AtMostOnceDelivery := 0,       //最多一次AtLeastOnceDelivery :=1,       //至少一次ExactlyOnceDelivery := 2       //确切一次 |
| **返回值**    | Bool             | 订阅是否成功，TRUE成功，FALSE不成功                                                                                          |

---

**方法FB\_IotMqttClient.Unsubscribe()介绍**

Bool **Unsubscribe(String&#x20;**&#x73;Topi&#x63;**)；**

| **接口**     | **类型** | **说明**                   |
| ---------- | ------ | ------------------------ |
| **sTopic** | String | 取消订阅消息的主题                |
| **返回值**    | Bool   | 取消订阅是否成功，TRUE成功，FALSE不成功 |

---
**方法FB\_IotMqttMessageQueue.Dequeue()介绍**

Bool **Dequeue(POINTER TO FB\_IotMqttMessage&#x20;**&#x66;bMessag&#x65;**)；**

| **接口**        | **类型**                        | **说明**                                                                   |
| ------------- | ----------------------------- | ------------------------------------------------------------------------ |
| **fbMessage** | POINTER TO FB\_IotMqttMessage | 指针，指向FB\_IotMqttMessage&#xA;从当前的消息队列里面获取一条消息，并赋值给FB\_IotMQttMessage消息的对象 |
| **返回值**       | Bool                          | 获取消息是否成功，TRUE成功，FALSE不成功                                                 |

---

**方法FB\_IotMqttMessageQueue.ResetQueue()介绍**

Bool **ResetQueue()；**

| **接口**  | **类型** | **说明**                          |
| ------- | ------ | ------------------------------- |
| **返回值** | Bool   | 清空当前消息队列里面的所有消息，TRUE成功，FALSE不成功 |

---

**方法FB\_IotMqttMessage.CompareTopic()介绍**

Bool **CompareTopic(String&#x20;**&#x73;Topi&#x63;**)；**

| **接口**     | **类型** | **说明**                                      |
| ---------- | ------ | ------------------------------------------- |
| **sTopic** | String | 比较输入的Topic                                  |
| **返回值**    | Bool   | 比较输入的Topic与当前消息的Topic 是否一致，TRUE为一致，FALSE不一致 |

---
**方法FB\_IotMqttMessage.GetTopic()介绍**

Bool **GetTopic(POINTER TO STRING&#x20;**&#x70;Topi&#x63;**，UINT&#x20;**&#x6E;TopicSiz&#x65;**)；**

| **接口**         | **类型**            | **说明**                        |
| -------------- | ----------------- | ----------------------------- |
| **pTopic**     | POINTER TO STRING | 指针指向主题消息内容                    |
| **nTopicSize** | UINT              | 主题消息长度                        |
| **返回值**        | Bool              | 获取消息的Topic，TRUE获取成功，FALSE获取失败 |

---
**方法FB\_IotMqttMessage.GetPayload()介绍**

Bool **GetPayload(PVOID&#x20;**&#x70;Payloa&#x64;**，UDINT&#x20;**&#x6E;PayloadSiz&#x65;**，BOOL&#x20;**&#x62;SetNullTerminatio&#x6E;**)；**

| **接口**                  | **类型** | **说明**                                  |
| ----------------------- | ------ | --------------------------------------- |
| **pPayload**            | PVOID  | 指针指向负载消息内容                              |
| **nPayloadSize**        | UDINT  | 负载消息内容长度                                |
| **bSetNullTermination** | Bool   | 消息是否以NULL字符结束（即‘\0’），TRUE为是，FALSE为否     |
| **返回值**                 | Bool   | 获取消息的负载，也就是订阅收到的消息内容，TRUE获取成功，FALSE获取失败 |